<?php

class WERBUNG{
	private $db;
	private $post = array();
	private $error = 0;
	private $meldung = '';
	private $menge = 0;
	private $mail;
	private $gconf;
	
	function __construct(){
		global $datenbank,$grundconfig;
		require_once('../lib/extra/mail.php');
		$this->mail = new send_smtp_mail;
		$this->db = $datenbank;
		$this->gconf = $grundconfig;
	}
	
	private function make_array($post){
		foreach($post AS $key => $value){
			if($key != '' && $key != 'run'){
				if($key == 'PaidmailMenge'){
					$this->menge = $this->db->escape($value);
				}else{
					$this->post[$key] = $this->db->escape($value);
				}
			}
		}
	}
	
	private function pruefen(){
		if(!is_numeric($this->post['menge'])){$this->error = 1; $this->meldung .= FB_MENGE_FALSE;}
		if(!$this->post['banner'] or !$this->post['menge'] or !$this->post['ziel'] or !$this->post['reload']){ $this->error = 1; $this->meldung .= FB_FELDER_FALSE;}
		if($this->post['reload'] < 1 or $this->post['reload'] > 1440 or !is_numeric($this->post['reload'])){ $this->error = 1; $this->meldung .= FB_RELOAD_FALSE;}
		if($this->post['aufendhalt'] < 0 or $this->post['aufendhalt'] > 30 or !is_numeric($this->post['aufendhalt'])){ $this->error = 1; $this->meldung .= FB_AUFENTHALT_FALSE;}
		if($this->post['aufendhalt'] > 30 or $this->post['aufendhalt'] < 0 or !is_numeric($this->post['aufendhalt'])){$this->error = 1; $this->meldung .= FB_AUFENTHALT_NUMERIC;}
	}
	
	private function insert(){
		unset($this->post['gesendet']);
		if($this->error == 0){
			$insert = $this->db->insert(PREFIX . WERBUNG, $this->post);
			if($insert == true){
				$this->meldung = FB_INSERT_TRUE;
			}else{
				$this->error = 1;
				$this->meldung = FB_INSERT_FALSE;
			}
		}
	}
	
	private function MailSenden(){
		$this->insert();
		$betreff = 'Neue ' . $this->gconf->seitenname . ' Paidmail';
		$query = "SELECT e.uid,e.emailadresse FROM
									" . PREFIX . EMAIL . " e
									LEFT JOIN " . PREFIX . KONTO . " k ON k.uid=e.uid
									WHERE (e.freigabe_fuer = '3' or e.freigabe_fuer = '2') AND k.status=1 ORDER BY RAND() LIMIT " . $this->menge . "";
		$results = $this->db->get_results($query);
		foreach($results AS $res){
			$ArrayUser = array(
				"uid" => $res->uid,
				"tan" => $this->post['tan'],
				"status" => 0,
				"aufendhalt" => $this->post['aufendhalt']
			);
			$message = 'Hallo,<br>
			dieses ist eine neue ' . $this->gconf->seitenname . ' Paidmail, für dessen Bestätigung<br>
			Du ' . $this->post['verdienst'] . ' ' . $this->gconf->waehrung . ' für ' . $this->post['aufendhalt'] . ' Sek. aufenthalt erhälst!<br>
			<br>
			' . $this->post['betreff'] . '<br>
			<br>
			' . $this->post['text'] . '<br>
			--------------------------------------------------------------------<br>
			<br>
			Die Betreiber von ' . $this->gconf->seitenname . ' distanzieren sich vom Inhalt dieser Mail!<br>
			<br>
			Diese Mail ist kein Spam da der Empfänger als Mitglied von<br>
			' . $this->gconf->seitenname . ' dem Empfang zugestimmt hat.<br>
			<br>
			Bestätigungslink:<br>
			<a href="' . $this->gconf->domain . '/pclick.php?tan=' . $this->post['tan'] . '&uid=' . $res->uid . '">Klick</a><br>
			<br>
			Mit freundlichen Grüßen   <br>
			Das ' . $this->gconf->seitenname . ' Team';
			$this->mail->senden($res->emailadresse,$betreff,$message);
		}
		meldung(0,"Es wurden $this->menge Paidmails verschickt.<br>");
	}
	
	public function FBEintragen($post){
		$this->make_array($post);
		$this->pruefen();
		$this->insert();
		meldung($this->error,$this->meldung);
	}
	
	public function PaidMailSenden($post){
		$this->make_array($post);
		$this->MailSenden();
	}
	
	public function PaidMailHist(){
		$aus = '';
		$query = "SELECT * FROM " . PREFIX . PAIDMAILSEND . " ORDER BY gesendet DESC";
		if($this->db->num_rows($query) > 0){
			$result = $this->db->get_results($query);
			foreach($result AS $res){
				$aus .= '
					<div class="card">
						<div class="card-header">
							Paidmail: ' . $res->beschreibung .'
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col">
									<b>Tan:</b> ' . $res->tan . '<br>
									<b>Menge:</b> ' . $res->menge . '<br>
									<b>Bestätigt:</b> ' . $res->bestaedigt . ' (' . @round($res->bestaedigt / $res->menge * 100, 2) . ' %)
								</div>
								<div class="col">
									<b>Userverdienst:</b> ' . $res->verdienst . '<br>
									<b>Gültig bis:</b> ' . date("d.m.Y - H:i", $res->gueltig) . '<br>
									<b>Gesendet am:</b> ' . date("d.m.Y - H:i", $res->gesendet) . '
								</div>
								<div class="col">
									<b>Aufenthalt:</b> ' . $res->aufendhalt . ' Sek.<br>
									<textarea class="form-control">' . $res->mailtext . '</textarea>
								</div>
							</div>';

				if ($res->gueltig <= time() or $res->menge == $res->bestaedigt) {
					$aus .= '<br><br><a href="?content=/werbesystem/paidmail_hist&amp;tan=' . $res->tan . '&amp;loeschen=true"><b>Löschen!</b></a>';
				}
				$aus .= '</div></div>';
			}
		}else{
			$aus = 'Momentan sind keine Paidmails verf&uuml;gbar.';
		}
		return $aus;
	}
	
	public function BannerHist(){
		$aus = '';
		$query = "SELECT * FROM " . PREFIX . WERBUNG . " WHERE sponsor='administrator' and werbeart = 'forcedbanner' and status = '1' ORDER BY kid ASC";
		if($this->db->num_rows($query) > 0){
			$result = $this->db->get_results($query);
			foreach($result AS $res){
				$aus .= '
					<div class="card" style="width: 468px;">
						<img class="card-img-top" src="'. $res->banner .'" alt="Card image cap">
						<div class="card-body">
							<span class="card-title">Tan: '. $res->tan .'</span>
							<br>
							<p class="card-text">
							<table class="table table-striped">
								<tr>
									<td>Verg&uuml;tung</td>
									<td>' . number_format($res->verdienst, 2, ",", ".") . '</td>
								</tr>
								<tr>
									<td>Ziel</td>
									<td><a href="https://' . $res->ziel . '" target="_new">' . $res->ziel . '</a></td>
								</tr>
								<tr>
									<td>Banner</td>
									<td><a href="' . $res->banner . '" target="_new">' . $res->banner . '</a></td>
								</tr>
								<tr>
									<td>Reload</td>
									<td>' . number_format($res->reload / 60,5,',','.') . 'h </td>
								</tr>
								<tr>
									<td>Rest</td>
									<td>' . number_format($res->menge, 0, ",", ".") . ' Klicks</td>
								</tr>
								<tr>
									<td>
										<form method="post" action="">
											<input type="hidden" name="id" value="'. $res->tan .'">
											<input type="submit" name="run[FBDelete]" value="L&ouml;schen" class="btn btn-danger btn-block">
										</form>
									</td>
								</tr>
							</table>
							</p>
						</div>
					</div>
				';
			}
		}else{
			$aus = '<div class="alert alert-info">Momentan sind keine Adminbanner vorhanden.</div>';
		}
		return $aus;
	}
	
	public function FBDelete($post){
		$tan = $this->db->escape($post['id']);
		$delete = $this->db->delete(PREFIX . WERBUNG, array("tan" => $tan), 1);
		if($delete == true){
			meldung(0,DELETE_BANNER_TRUE);
		}else{
			meldung(1,DELETE_BANNER_FALSE);
		}
	}
}
