<?php

class userliste{
	private $db;
	private $uid;
	private $array = array();
	private $seite;
	
	public function __construct(){
		global $datenbank;
		$this->db = $datenbank;
	}
	
	public function Refschleifen(){
		$aus = '<div class="alert alert-danger">';
		$i = 0;
		foreach($this->db->get_results("SELECT uid,werber FROM ". PREFIX . WERBER ."") AS $row){
			$sql2 = "SELECT * FROM ". PREFIX . WERBER ." WHERE uid = " . $row->werber . " AND werber=" . $row->uid;
			if ($this->db->num_rows($sql2) >= 1) {
				$row = $this->db->get_row($sql2,true);
				$i++;
				$aus .= 'F&uuml;r die UserId <a href="?page=/usersystem/details&uid='. $row->uid .'">' . $row->uid . '</a> existiert eine RefSchleife (Weber ' . $row->werber . ')!<br />';
			}
		}
		$aus .= '</div>';

		if ($i == 0) {
			$aus = '<div class="alert alert-success">Es sind keine RefSchleifen vorhanden!</div>';
		}
		return $aus;
	}
	
	public function DoppelAcc(){
		$query = "SELECT `login_ip`, COUNT(*) AS `anzahl` FROM  `" . PREFIX . KONTO . "` WHERE login_ip != '' GROUP BY `login_ip` HAVING COUNT(*) > 1 ";
		if($this->db->num_rows($query) == 0){
			$aus = '<div class="alert alert-success">'. DOPPEL_ACC_FALSE .'</div>';
		}else{
			$aus = $this->ListDoppelAcc($query);
		}
		return $aus;
	}
	
	private function ListDoppelAcc($query){
		$aus = '<ul class="list-group">';
		foreach($this->db->get_results($query) AS $res){
			$aus .= '<li class="list-group-item">
						<div class="row">
							<div class="col-md-5">'. $res->login_ip .'</div>
							<div class="col-md-5">'. $res->anzahl .' mal vorhanden</div>
							<div class="col-md-2"><a class="btn btn-info" href="?page=/usersystem/doppelaccis&ip='. $res->login_ip .'">Details</a></div>
						</div>
					</li>';
		}
		$aus .= '</ul>';
		return $aus;
	}
	
	public function DoppelAccIP($ip){
		if(!filter_var($ip, FILTER_VALIDATE_IP)){ $ip = 0; }
		$aus = '<hr><div class="card"><div class="card-header">User mit der IP: '.$ip.'</div><div class="card-body">';
		$query = "SELECT k.uid,u.nickname FROM
                 " . PREFIX . KONTO . " AS k
                 LEFT JOIN " . PREFIX . USER . " AS u ON u.uid=k.uid
				 WHERE k.login_ip='$ip'";
		foreach($this->db->get_results($query) AS $res){
			$aus .= "<a href='?page=/usersystem/details&uid=$res->uid'>$res->nickname</a><br>";
		}
		$aus .= '</div></div>';
		return $aus;
	}
	
	public function DoppelPass(){
		$query = "SELECT `passwort`, COUNT(*) AS `anzahl` FROM  `" . PREFIX . KONTO . "` GROUP BY `passwort` HAVING COUNT(*) > 1";
		if($this->db->num_rows($query) == 0){
			$aus = DOPPEL_PASS_FALSE;
		}else{
			$aus = $this->DoppelAccPass($query);
		}
		return $aus;
	}
	
	private function DoppelAccPass($query){
		$aus = '<ul class="list-group">';
		foreach($this->db->get_results($query) AS $res){
			$aus .= '<li class="list-group-item">
						<div class="row">
							<div class="col-md-7">'. $res->passwort .'</div>
							<div class="col-md-2">'. $res->anzahl .' mal vorhanden</div>
							<div class="col-md-2"><a class="btn btn-info" href="?page=/usersystem/doppelaccis&md5='. $res->passwort .'">Details</a></div>
						</div>
					</li>';
		}
		$aus .= '</ul>';
		return $aus;
	}
	
	public function DoppelPassList($md5){
		$md5 = addslashes(htmlspecialchars($md5));
		$aus = '<hr><div class="card"><div class="card-header">User mit dem Hash: '.$md5.'</div><div class="card-body">';
		$query = "SELECT k.uid,u.nickname FROM
                 " . PREFIX . KONTO . " AS k
                 LEFT JOIN " . PREFIX . USER . " AS u ON u.uid=k.uid
			     WHERE k.passwort='$md5'";
		foreach($this->db->get_results($query) AS $res){
			$aus .= "<a href='?page=/usersystem/details&uid=$res->uid'>$res->nickname</a><br>";
		}
		$aus .= '</div></div>';
		return $aus;
	}
	
	public function liste(){
		$aus = '
		<table class="table table-bordered table-striped" id="Userliste">
			<thead>
				<tr>
					<th>UID</th>
					<th>
						Kontostand<br>
						<small><i>(W&auml;hrung/Bonusw&auml;hrung)</i></small>
					</th>
					<th>Nickname</th>
					<th>Name</th>
					<th>Nachname</th>
					<th>Emailadresse</th>
					<th>Angemeldet</th>
					<th></th>
				</tr>
			</thead>
			<tbody>';
		$daten = $this->db->get_results("
									SELECT 
										u.*,k.kontostand_a,k.kontostand_b,k.status,e.emailadresse 
									FROM 
										". PREFIX . KONTO ." AS k
									LEFT JOIN
										". PREFIX . USER ." AS u 
									ON 
										u.uid=k.uid
									LEFT JOIN 
										" . PREFIX . EMAIL . " AS e 
									ON 
										e.uid=k.uid
									ORDER BY 
										k.uid ASC ");
		foreach($daten AS $dat){
			if($dat->status == 0){
				$icon = 'glyphicon-ban-circle';
				$alt = 'Best&auml;tigung fehlt';
				$color = 'yellow';
			}elseif($dat->status == 1){
				$icon = 'glyphicon-ok-circle';
				$alt = 'freigeschaltet';
				$color = 'green';
			}elseif($dat->status == 2){
				$icon = 'glyphicon-remove-circle';
				$alt = 'Gesperrt';
				$color = 'red';
			}
			$aus .= "
				<tr>
					<td>$dat->uid</td>
					<td>".number_format($dat->kontostand_a,2,',','.') ."/". number_format($dat->kontostand_b,2,',','.') ."</td>
					<td>$dat->nickname</td>
					<td>$dat->vorname</td>
					<td>$dat->nachname</td>
					<td>$dat->emailadresse</td>
					<td>". date("d.m.Y H:i",$dat->angemeldet_seit) ."</td>
					<td><a href='?page=/usersystem/details&uid=". $dat->uid ."' class='btn btn-default'>Details</a></td>
				</tr>";
		}
		$aus .= '</tbody></table>';
		return $aus;
	}
	
	public function profil_save($post){
		global $meldung;
		$this->make_array($post);
		$user = array("nickname" => $this->array['nickname']);
		$mail = array("emailadresse" => $this->array['emailadresse'], "freigabe_fuer" => $this->array['freigabe_fuer']);
		$konto = array(
			"bettel_sperre" => $this->array['bettel_sperre'],
			"forced_sperre" => $this->array['forced_sperre'],
			"chat_sperre" => $this->array['chat_sperre'],
			"auszahlung_sperre" => $this->array['auszahlung_sperre']
		);
		$update = $this->db->update(PREFIX . KONTO , $konto, array("uid" => $this->uid));
		$update = $this->db->update(PREFIX . EMAIL , $mail, array("uid" => $this->uid));
		$update = $this->db->update(PREFIX . USER , $user, array("uid" => $this->uid));
		$update = $this->db->update(PREFIX . WERBER, array("werber" => $this->array['werber']), array("uid" => $this->uid));
		$meldung = ALLGEMEINE_DATEN_SAVE;
	}
	
	private function make_array($post){
		foreach($post AS $key => $value){
			if($key != 'profile_save' && $key != 'notice'){
				$this->array[$key] = $value;
			}
		}
	}
	
	public function set_uid($uid){
		if(!is_numeric($uid)){ $this->uid = 0;}else{$this->uid = $uid;}
	}
	
	public function startseite(){
		$erg = $this->db->get_row("SELECT COUNT(uid) AS kd_uid , SUM(kontostand_a) AS kd_kontostand FROM ". PREFIX . KONTO ."",true);
		return $erg;
	}
	
	public function Chart(){
		$array = array("label" => "", "ges" => "");
		$result = $this->db->get_results("SELECT datum,SUM(ein) AS ein, SUM(aus) as aus FROM ". PREFIX . BILANZ ." GROUP BY datum ORDER BY datum ASC LIMIT 14");
		foreach($result AS $res){
			$array['label'] .= 	'"'.date("d.m.",$res->datum).'"' .",";
			$array['ges'] .= $res->ein - $res->aus .',';
		}
		
		return $array;
	}
	
	public function userinfo(){
		$daten = $this->db->get_row("
					SELECT 
						u.*,k.*,b.*,e.*,w.* 
					FROM 
						". PREFIX . KONTO ." AS k
					LEFT JOIN
						". PREFIX . USER ." AS u 
					ON 
						u.uid=k.uid
					LEFT JOIN 
						" . PREFIX . EMAIL . " AS e 
					ON 
						e.uid=k.uid
					LEFT JOIN
						". PREFIX . BUCH ." AS b
					ON
						b.uid = k.uid
					LEFT JOIN 
						". PREFIX . WERBER ." AS w
					ON
						w.uid = k.uid
					WHERE k.uid = '$this->uid'
					",true);
		return $daten;
	}
	
	public function set_bseite($seite){
		$this->seite = $seite * 30 - 30;	
	}
	
	public function buchungen($seite = 0){
		$aus = array("A" => "", "B" => "");
		$bua = $this->db->get_results("SELECT * FROM ". PREFIX . BUCH." WHERE uid='$this->uid' ORDER BY buchungszeit  DESC LIMIT $this->seite,30");
		foreach($bua AS $b){
			if($b->buchungsmenge < 0){ $style = 'class="alert alert-danger"';}else{ $style = 'class="alert alert-success"';}
			if($b->buchung_ok == 1){
				$erfolg = '<span class="glyphicon glyphicon-ok" style="color:green;" aria-hidden="true"></span>';
			}else{
				$erfolg = '<span class="glyphicon glyphicon-remove" style="color:red" aria-hidden="true"></span>';
			}
			$aus['A'] .= '
				<tr '.$style.'>
					<td>'. date("d.m.Y H:i",$b->buchungszeit) .'</td>
					<td>'. $b->buchungs_id .'</td>
					<td>'. number_format($b->buchungsmenge,2,',','.') .'</td>
					<td>'. $b->verwendungszweck .'</td>
					<td>'. $b->buchungs_id .'</td>
					<td class="text-center">'. $erfolg .'</td>
				</tr>
			';
		}
		
		$bub = $this->db->get_results("SELECT * FROM ". PREFIX . BUCH_B ." WHERE uid='$this->uid' ORDER BY buchungszeit  DESC LIMIT $this->seite,30");
		foreach($bub AS $b){
			if($b->buchungsmenge < 0){ $style = 'class="alert alert-danger"';}else{ $style = 'class="alert alert-success"';}
			if($b->buchung_ok == 1){
				$erfolg = '<span class="glyphicon glyphicon-ok" style="color:green;" aria-hidden="true"></span>';
			}else{
				$erfolg = '<span class="glyphicon glyphicon-remove" style="color:red" aria-hidden="true"></span>';
			}
			$aus['B'] .= '
				<tr '.$style.'>
					<td>'. date("d.m.Y H:i",$b->buchungszeit) .'</td>
					<td>'. $b->buchungs_id .'</td>
					<td>'. number_format($b->buchungsmenge,2,',','.') .'</td>
					<td>'. $b->verwendungszweck .'</td>
					<td>'. $b->buchungs_id .'</td>
					<td class="text-center">'. $erfolg .'</td>
				</tr>
			';
		}
		
		return $aus;
	}
	
	public function bettel_ref(){
		$aus = '';
		$result = $this->db->get_results("SELECT * FROM ". PREFIX . BETTELB ." WHERE uid = '$this->uid' ORDER BY id DESC LIMIT 120");
		foreach($result AS $res){
			$aus .= '
				<tr>
					<td>'.date("d.m.Y - H:i", $res->zeit).'</td>
					<td>'.number_format($res->betrag,2,",",".").'</td>
					<td><a href="'.$res->refferer.'" target="_new">'.$res->refferer.'</a></td>
				</tr>
			';
		}
		return $aus;
	}
	
	public function ShowNotizen(){
		$result = $this->db->get_results("SELECT * FROM ". PREFIX . NOTIZ ." WHERE uid = '$this->uid' ");
		foreach($result AS $res){
			echo '
			 <li class="list-group-item">
				<div class="row">
					<div class="col-md-3">'. date("d.m.Y", $res->datum) .'</div>
					<div class="col-md-9">'. nl2br($res->text) .'</div>
				</div>
			</li>
			';
		}
	}
	
	public function AddNotiz(){
		global $_POST,$_GET,$error,$meldung;
		$this->make_array($_POST);
		if(empty($this->array['text'] )){ $error = 1; $meldung .= NOTIZ_EMPTY;}
		if($error == 0){
			$eintrag = array(
				"uid" => $this->uid,
				"text" => $this->array['text'],
				"datum" => time()
			);
			$insert = $this->db->insert(PREFIX . NOTIZ, $eintrag);
			if($insert == true){
				$meleung = NOTIZ_SAVE_TRUE;
			}else{
				$error = 1;
				$meldung = NOTIZ_SAVE_FALSE;
			}
		}
	}
}
