<?php

class rally{
	private $db;
	private $error = 0;
	private $meldung;
	private $post = array();
	private $bilanz;
	
	function __construct(){
		global $datenbank;
		$this->db = $datenbank;
		$this->bilanz = Classloader('bilanz');
	}
	
	public function RallyListe(){
		$aus = '';
		foreach($this->db->get_results("SELECT * FROM ". PREFIX . RALLY ." ") AS $res){
			$aus .= '
				 <form action="" method="post">
					<tr>
						<td>'. $res->name .'</td>
						<td>
							<input type="hidden" name="id" value="'. $res->id .'">
							<input type="submit" name="rallyDelete" class="btn btn-danger" value="L&ouml;schen" style="width:100px;">
						</td>
					</tr>
				</form>
			';
		}
		return $aus;
	}
	
	public function RallyDaten(){
		$aus = '';
		foreach($this->db->get_results("SELECT id,name FROM ". PREFIX . RALLY ." ") AS $res){
			$aus .= '<input type="checkbox" value="1" name="rally[' . $res->id . ']"> ' . $res->name . '<br>';
		}
		return $aus;
	}
	
	public function RallyOrte(){
		$aus = '<table class="table table-striped">
					<tr>
						<th>Diese ID<br>müssen Sie<br>in der <br>Funktion<br>eingeben</th>
						<th>Beschrieb</th>
						<th>Welche rallys</th>
						<th>Bearbeiten<br>der <br>einzelnen <br>Positionen</th>
					</tr>';
		foreach($this->db->get_results("SELECT * FROM ". PREFIX . RALLYO ." ") AS $res){
			$ausgabe = '';
			foreach($this->db->get_results("SELECT id, name FROM " . PREFIX . RALLY . " ") AS $res2){
				$checked = '';
				if(in_array($res2->id, explode(",",$res->welche_rallys))){ $checked = 'checked="checked"';}
				$ausgabe .= '<input type="checkbox" ' . $checked . ' value="1" name="rally[' . $res2->id . ']"> ' . $res2->name . '<br>';
			}
			
			$aus .= '
				<tr>
					<form action="" method="post">
						<td><input type="hidden" name="id" value="'. $res->id .'">'. $res->id .'</td>
						<td>'. $res->name .'</td>
						<td>'. $ausgabe .'</td>
						<td>
							<input type="submit" name="OrtEdit" value="bearbeiten" class="btn btn-success"><br>
							<input type="submit" name="OrtDelete" value="L&ouml;schen" class="btn btn-danger">
						</td>
					</form>
				</tr>
			';
		}
		$aus .= '</table>';
		return $aus;
	}
	
	private function make_array($post){
		foreach($post AS $key => $value){
			if($key != '' && $key != 'run'){
				$this->post[$key] = $this->db->escape($value);
			}
		}
	}
	
	public function NeueRally($post){
		$this->make_array($post);
		if($this->db->insert(PREFIX . RALLY, array("name" => $this->post['rallyname']) ) == true){
			meldung(0,RALLY_ADD_SAVE_TRUE);
		}else{
			meldung(1,RALLY_ADD_SAVE_FALSE);
		}
	}
	
	public function Delete($post){
		$this->make_array($post);
		if($this->db->delete(PREFIX . RALLY, array("id" => $this->post['id']),1) == true){
			meldung(0,RALLY_DELETE_TRUE);
		}else{
			meldung(1,RALLY_DELETE_FALSE);
		}
	}
	
	public function AddOrt($post){
		$this->make_array($post);
		foreach(array_keys($post['rally']) AS $res){
			if(!is_numeric($res)){ $this->error = 1;}
		}
		if($this->error == 0){
			$this->post['rally'] = implode(',', array_keys($post['rally']));
			$array = array(
				"name" => $this->post['name'],
				"welche_rallys" => $this->post['rally']
			);
			if($this->db->insert(PREFIX . RALLYO, $array) == true){
				meldung(0,RALLY_ADD_ORT_TRUE);
			}else{
				meldung(1,RALLY_ADD_ORT_FALSE);
			}
		}else{
			meldung(1,RALLY_ADD_ORT_ERROR);
		}
	}
	
	public function EditOrt($post){
		$this->make_array($post);
		foreach(array_keys($post['rally']) AS $res){
			if(!is_numeric($res)){ $this->error = 1;}
		}
		if($this->error == 0){
			if($this->db->update(PREFIX . RALLYO, array("welche_rallys" => implode(',', array_keys($post['rally'])) ), array("id" => $this->post['id'])) == true){
				meldung(0,RALLY_ORT_EDIT_TRUE);
			}else{
				meldung(1,RALLY_ORT_EDIT_FALSE);
			}
		}else{
			meldung(1,RALLY_ADD_ORT_ERROR);
		}
	}
	
	public function OrtDelete($post){
		$this->make_array($post);
		if($this->db->delete(PREFIX . RALLYO, array("id" => $this->post['id'])) == true){
			meldung(0,RALLY_ORT_DELETE_TRUE);
		}else{
			meldung(1,RALLY_ORT_DELETE_FALSE);
		}
	}
	
	public function verteilung($id,$daten){
		$aus = '<form method="post" action=""><div class="row">';
		$ii = 1;
		for($i = 1; $i <= 50; $i++){
			$pl = 'p'.$i;
			$aus .= '<div class="col">
						<div class="input-group mb-3">
							<div class="input-group-prepend">
								<span class="input-group-text" id="basic-addon1">'. $i .'</span>
							</div>
							<input type="text" name="p'.$i.'" value="'. $daten->$pl .'" class="form-control">
						</div>
					</div>';
			if($ii == 5){
				$ii = 1;
				$aus .= '</div><div class="row">';
			}else{
				$ii++;
			}
		}
		$aus .= '</div><br><input type="submit" name="run[rally_verteilung]" value="Speichern" class="btn btn-success btn-block"></form>';
		return $aus;
	}
	
	public function PlatzUndVerteilung($daten){
		$gesperrt = explode(";",$daten->sperruser);
		$i = 1;
		$aus = '
		<form method="post" action="">
		<input type="hidden" name="name" value="'. $daten->name .'">
			<div class="row">
				<div class="col">
					<input type="Submit" name="run[RallyReset]" value="Reseten" class="btn btn-danger btn-block">
				</div>
				<div class="col">
					<input type="Submit" name="run[RallyAuswerten]" value="Auswerten" class="btn btn-success btn-block">
				</div>
			</div>
		</form>
		<hr>
		<table class="table table-striped">
			<tr >
				<th width="30"><b>Rang</b></th>
				<th><b>User</b></th>
				<th>'. $daten->einheit.'</th>
				<th><b>möglicher Gewinn</th>
				<th><b>Mindestpunktzahl</th>
			</tr>
		';
		foreach($this->db->get_results("SELECT uid,punkte FROM ". PREFIX . RALLYU ." WHERE rally = '$daten->id' ORDER BY punkte DESC LIMIT 50") AS $res){
			$pl = 'p'.$i;
			$user = userinfo($res->uid);
			$erreicht = '<td class="alert-danger">nicht erreicht</td>';
			if($daten->$pl >= $res->punkte){ $erreicht = '<td class="alert-success">erreicht</td>';}
			$explode = explode(",",$daten->sperruser);
			if(!in_array($res->uid,$explode)){
				$aus .= ' 
					<tr>
						<td>'. $i .'</td>
						<td>'. $user->nickname .'</td>
						<td>'. $res->punkte .'</td>
						<td>'. number_format(($daten->gewinn_topf / 100 * $daten->$pl), 2, ',', '.') . '</td>
						'. $erreicht .'
					</tr>
				';
			}
			$i++;
		}
		$aus .= '</table>';
		return $aus;
	}
	
	public function ConfigSave($post){
		$this->make_array($post);
		if($this->db->update(PREFIX . RALLY, $this->post,array("name" =>$this->post['name'])) == true){
			meldung(0,RALLY_CONFIG_SAVE_TRUE);
		}else{
			meldung(1,RALLY_CONFIG_SAVE_FALSE);
		}
	}
	
	public function verteilungSave($post,$get){
		$this->make_array($post);
		$array = array();
		for($i = 1; $i <= 50; $i++){
			$array['p'.$i] = $this->post['p'.$i];
		}
		
		if($this->db->update(PREFIX . RALLY, $array, array("id" => $this->db->escape($get['rally']))) == true){
			meldung(0,RALLY_VERTEILUNG_SAVE_TRUE);
		}else{
			meldung(1,RALLY_VERTEILUNG_SAVE_FALSE);
		}
	}
	
	public function RallyReset($post){
		$this->make_array($post);
		$row = $this->db->get_row("SELECT * FROM ". PREFIX . RALLY ." WHERE name = '". $this->post['name'] ."' ",true);
		if($this->db->delete(PREFIX . RALLYU, array("rally" => $row->id)) == true){$error1 = true;}else{ $error1 = false;}
		if($this->db->update(PREFIX . RALLY, array("ende_punkte_aktuell" => '0', "gewinn_topf" => $row->tagpotstart), array("id" => $row->id),1) == true){ $error2 = true;}else{ $error2 = false;}
		
		if($error1 == true && $error2 == true){
			meldung(0,RALLY_RESET_TRUE);
		}else{
			meldung(1,RALLY_RESET_FALSE);
		}
	}
	
	public function RallyAuswerten($post,$get){
		$konto = Classloader('konto',true);
		$rp = 1;
		$this->make_array($post);
		$this->make_array($get);
		$row = $this->db->get_row("SELECT * FROM ". PREFIX . RALLY ." WHERE name = '". $this->post['name'] ."' ",true);
		foreach($this->db->get_results("SELECT * FROM ". PREFIX . RALLYU ." WHERE rally = '$row->id' AND ausgezahlt = '0' AND punkte >= '$row->mindestpunktzhl' ORDER BY punkte DESC LIMIT $row->gewinner_anzahl ") AS $res){
			$pl = 'p'.$rp;
			$gewinn = $row->gewinn_topf / 100 * $row->$pl;
			$konto->set_var($res->uid,$gewinn,'+','Gewinn '.$row->name .' Platz '. $rp);
			$this->db->update(PREFIX . RALLYU,array("auszahlungssumme" => $gewinn),array("uid" => $res->uid, "ausgezahlt" => '0',"rally" => $row->id),1);
			$this->meldung .= ' Die UID ' . $res->uid . ' wahr auf Platz' . $rp . ' und hatt' . $gewinn . ' erhalten <br>';
			$this->bilanz->bilanz(0,$gewinn,'Rally',$row->name);
			$rp++;
		}
		$this->db->delete(PREFIX . RALLYU, array("rally" => $row->name, "ausgezahlt" => '0'));
		$this->db->update(PREFIX . RALLY, array("ende_punkte_aktuell" => '0', "gewinn_topf" => $row->tagpotstart), array("id" => $row->id),1);
		$this->meldung .= RALLY_AUSWERTUNG_TRUE;
		meldung(0,$this->meldung);
	}
}
