<?php

class NEWS{
	private $db;
	private $error = 0;
	private $meldung;
	private $array = array();
	private $config;
	
	function __construct(){
		global $datenbank,$grundconfig;
		$this->db = $datenbank;
		$this->config = $grundconfig;
	}
	
	private function make_array($post){
		foreach($post AS $key => $value){
			if($key != '' && $key != 'news4' && $key != 'news3' && $key != 'news2'){
				$this->array[$key] = $this->db->escape($value);
			}
		}
	}
	
	private function save(){
		if($this->db->insert(PREFIX . NEWS, array("zeit" => time(), "titel" => $this->array['titel'], "news" => $this->array['news'])) == true){
			$this->meldung = NEWS_SAVE_TRUE;
		}else{
			$this->error = 1;
			$this->meldung = NEWS_SAVE_FALSE;
		}
	}
	
	private function newsletter(){
		require_once('../lib/extra/mail.php');
		$mail = new send_smtp_mail;
		foreach($this->db->get_results("SELECT emailadresse FROM ". PREFIX . EMAIL ." WHERE freigabe_fuer = '1' ") AS $res){
			$mail->senden($res->emailadresse,$this->array['titel'],$this->array['news']);
		}
	}
	
	private function deleteDB(){
		if($this->db->delete(PREFIX . NEWS, array("id" => $this->array['id'])) == true){
			$this->meldung = NEWS_DELETE_TRUE;
			$this->db->delete(PREFIX . NEWSK, array("news" => $this->array['id']));
		}else{
			$this->error = 1;
			$this->meldung = NEWS_DELETE_FALSE;
		}
	}
	
	public function delete($post){
		$this->make_array($post);
		$this->deleteDB();
		meldung($this->error,$this->meldung);
	}
	
	public function news3($post){
		$this->make_array($post);
		$this->newsletter();
		meldung($this->error,NEWS_NEWSLETTER_TRUE);
	}
	
	public function news2($post){
		$this->make_array($post);
		$this->save();
		$this->newsletter();
		meldung($this->error,NEWS_MAIL_SAVE_TRUE);
	}
	
	public function news4($post){
		$this->make_array($post);
		$this->save();
		meldung($this->error,$this->meldung);
	}
	
	public function edit(){
		$aus = '
		<form method="post" action="">
			<div class="input-group mb-3">
				<select class="custom-select" name="id">
					<option value="0">bitte w&auml;hlen</option>
					'. $this->ListeNews() .'
				</select>
				<div class="input-group-append">
					<input type="submit" class="btn btn-success" value="bearbeiten">
					<input type="submit" class="btn btn-danger" name="news_delete" value="l&ouml;schen">
				</div>
			</div>
		</form>
		';
		return $aus;
	}
	
	private function ListeNews(){
		$aus = '';
		foreach($this->db->get_results("SELECT id,titel,zeit FROM ". PREFIX . NEWS ." ") AS $res){
			$datum = date("d.m.Y H:i",$res->zeit);
			$aus .= "<option value='$res->id'>$res->titel ($datum)</option>";
		}
		return $aus;
	}
		
}
