<?php

class konto{
	
	private $uid;
	private $betrag;
	private $art;
	private $verwendung;
	private $empfanger;
	private $db;
	
	public function __construct(){
		global $datenbank;
		$this->db = $datenbank;
	}
	
	public function set_var($uid,$betrag,$art,$verwendung,$empfaenger = 0){
		$this->set_uid($uid);
		$this->set_betrag($betrag);
		$this->set_art($art);
		$this->set_verw($verwendung);
		if($empfaenger != 0){ $this->set_empfaenger($empfaenger);}
		if($art == '-'){
			$this->abzug();
		}else{
			$this->gutschrift();
		}
	}
	
	private function set_empfaenger($uid){
		$this->empfanger = $uid;
	}
	
	private function set_verw($verw){
		$this->verwendung = $verw;
	}
	
	private function set_uid($uid){
		if(!is_numeric($uid)){ $this->uid = 0;}else{ $this->uid = $uid;}
	}
	
	private function set_betrag($betrag){
		if(!is_numeric($betrag)){ $this->betrag = 0;}else{ $this->betrag = str_replace(",",".",$betrag);}
	}
	
	private function set_art($art){
		$this->art = $art;
	}
	
	private function abzug(){
		$konto = $this->kontostand();
		$konto_neu = $konto->kontostand - $this->betrag;
		$this->db->update(PREFIX . KONTO , array("kontostand_a" => $konto_neu) , array("uid" => $this->uid),1 );
		$this->buchungsliste();
	}
	private function gutschrift(){
		$konto = $this->kontostand();
		$konto_neu = $konto + $this->betrag;
		$buchung_ok = $this->db->update(PREFIX . KONTO , array("kontostand_a" => $konto_neu) , array("uid" => $this->uid),1 );
		$this->buchungsliste($buchung_ok);
	}
	
	private function buchungsliste($buchung_ok){
		$buch = array(
			"uid" => $this->uid,
			"buchungszeit" => time(),
			"buchungs_id" => create_code(11),
			"buchungsmenge" => $this->art . $this->betrag,
			"verwendungszweck" => $this->verwendung
		);
		if($buchung_ok == true){ $buch['buchung_ok'] = 1;}
		$this->db->insert(PREFIX . BUCH , $buch);
	}
	
	private function kontostand(){
		$return = $this->db->get_row("SELECT kontostand_a FROM ". PREFIX . KONTO ." WHERE uid = '$this->uid' ",true);
		return $return->kontostand_a;
	}
}
