<?php

class BUCHUNG{
	private $db;
	private $start;
	private $SitesComplete;
	private $extVariables = '';
	private $seiteAktuell = 0;
	const MAXEIN = 100;
	const NAV_LEISTE = 30;
	
	function __construct(){
		global $datenbank;
		$this->db = $datenbank;
	}
	
	public function SetStart($start){
		$this->seiteAktuell = $start;
		$this->start = $start * 100 - 100;
	}
	
	public function Auflisten(){
		$this->SitesComplete = ceil($this->db->num_rows("SELECT * FROM ". PREFIX . BUCH ." ") / self::MAXEIN);
		echo $this->navigationsLeiste('minus','?page=/buchungen');
		echo $this->Liste();
	}
	
	private function Liste(){
		$aus = "<ul class='list-group'>
					<li class='list-group-item'>
						<div class='row'>
							<div class='col-md-2'>User</div>
							<div class='col-md-2'>Datum</div>
							<div class='col-md-2'>Buchungs-ID</div>
							<div class='col-md-2'>Buchungsmenge</div>
							<div class='col-md-3'>Verwendungszweck</div>
							<div class='col-md-1'>Buchung Eroflgreich</div>
						</div>
					</li>";
		$start = ($this->seiteAktuell * self::MAXEIN) - self::MAXEIN;
		foreach($this->db->get_results("SELECT * FROM ". PREFIX . BUCH ." ORDER BY id DESC LIMIT $start, ".self::MAXEIN ." ") AS $res){
			if($res->buchung_ok == 1){
				$ok = '<img src="https://img.icons8.com/material/24/000000/checked.png" style="color:green;">';
			}else{
				$ok = '<img src="https://img.icons8.com/material/24/000000/close-window.png" style="color:red">';
			}
			$aus .= "<li class='list-group-item'>
						<div class='row'>
							<div class='col-md-2'>User: $res->uid</div>
							<div class='col-md-2'>". date("d.m.Y H:i",$res->buchungszeit) ."</div>
							<div class='col-md-2'>$res->buchungs_id</div>
							<div class='col-md-2'>". number_format($res->buchungsmenge,2,',','.') ."</div>
							<div class='col-md-3'>$res->verwendungszweck</div>
							<div class='col-md-1'>$ok</div>
						</div>
					</li>";
		}
		$aus .= '</ul>';
		return $aus;
	}
	
	private function navigationsLeiste($art,$link){      
		$string = '<div class="text-center">';
		$NavCeil = floor(self::NAV_LEISTE / 2);
		if($this->seiteAktuell > 1){
			$string .= '<a class="btn btn-light" href="'. $link .'&'.$art.'=1'.$this->extVariables.'"><<</a>&nbsp;&nbsp;';
			$string .= '<a class="btn btn-light" href="'. $link .'&'.$art.'='.($this->seiteAktuell-1).$this->extVariables.'"><</a>&nbsp;&nbsp;';
		}
		for($x = $this->seiteAktuell-$NavCeil;$x<=$this->seiteAktuell+$NavCeil;$x++){
			// Alle Seitenzahlen vor und nach der aktuellen Seite verlinken
			if(($x>0 && $x<$this->seiteAktuell) || ($x>$this->seiteAktuell && $x<=$this->SitesComplete))
				$string .= '<a class="btn btn-light" href="'. $link .'&'.$art.'='.$x.$this->extVariables.'">'.$x.'</a>&nbsp;&nbsp;';
			if($x==$this->seiteAktuell)
				$string .= '<button class="btn btn-primary" disabled="disabled">'.$x . '</button>';
		}
		if($this->seiteAktuell < $this->SitesComplete){
			$string .= '<a class="btn btn-light" href="'. $link .'&'.$art.'='.($this->seiteAktuell+1).$this->extVariables.'">>
			 </a>&nbsp;&nbsp;';
			$string .= '<a class="btn btn-light" href="'. $link .'&'.$art.'='.$this->SitesComplete.$this->extVariables.'">>>
			  </a>&nbsp;&nbsp;';
		}
		$string .= '</div><hr>';
		return $string;
		
	}
}
